"use strict"; 

/* setBodyClass */ 
var setBodyClass = function () { 
    var windowWidth = $(window).width();  
    if (windowWidth > 1420) { 
        $('body').removeClass('phone tablet pc').addClass('pc_large');
    }
    if ((windowWidth <= 1420) && (windowWidth > 960)) {
        $('body').removeClass('phone tablet pc_large').addClass('pc');
    }
    if ((windowWidth <= 960) && (windowWidth >= 768)) {
        $('body').removeClass('phone pc pc_large').addClass('tablet');
    }
    if (windowWidth < 767) {
        $('body').removeClass('tablet pc pc_large').addClass('phone');
    }
}

var globalTemplates_Click = function () {
    $('.global_templates .item').click(function () {
        if ($('body').hasClass('tablet') || $('body').hasClass('phone')) {
            if (!$(this).hasClass('act')) {
                $('.global_templates .item').removeClass('act');
                $(this).addClass('act'); 
            }
        }
    });
}

var globalTemplates_removeActiveTemplate = function () {
    if ( $('.global_templates').length < 1 ) {
        return false;
    }
    if ($('body').hasClass('pc_large') || $('body').hasClass('pc')) {
        $('.global_templates .item').removeClass('act');
    }
}

$(document).ready(function(){
    globalTemplates_Click();
    setBodyClass();
    $(".owl-carousel").owlCarousel({
        items : 1,
        nav: true,
        loop: true
    });
});

$(window).resize(function(){
    globalTemplates_removeActiveTemplate();
    setBodyClass();
});