$(window).load(function () {

    /* scroll width */
    var scrollWidth = 0;
    var getScrollBarWidth = function () {
        var inner = document.createElement('p');
        inner.style.width = "100%";
        inner.style.height = "200px";

        var outer = document.createElement('div');
        outer.style.position = "absolute";
        outer.style.top = "0px";
        outer.style.left = "0px";
        outer.style.visibility = "hidden";
        outer.style.width = "200px";
        outer.style.height = "150px";
        outer.style.overflow = "hidden";
        outer.appendChild(inner);

        document.body.appendChild(outer);

        var w1 = inner.offsetWidth;
        outer.style.overflow = 'scroll';
        var w2 = inner.offsetWidth;
        if (w1 == w2) w2 = outer.clientWidth;

        document.body.removeChild(outer);

        if ($("body").height() > $(window).height()) {
            scrollWidth = (w1 - w2);
        }
    }
    getScrollBarWidth();

    /* set body class */
    setBodyClass = function () {
        var ww = $(window).width() + scrollWidth;
        if (ww > 1200) {
            $('body').removeClass('phone tablet phone_land').addClass('pc');
        }
        if (ww >= 768 && ww <= 1200) {
            $('body').removeClass('phone pc phone_land').addClass('tablet');
        }
        if (ww >= 480 && ww < 768) {
            $('body').removeClass('pc tablet phone').addClass('phone_land');
        }
        if (ww < 480) {
            $('body').removeClass('pc tablet phone_land').addClass('phone');
        }
    }
    setBodyClass();

    $(window).resize(function () {
        setBodyClass();
    });

    /* scroll to anchor */
    $(function () {
        $('a[href*=#]:not([href=#])').click(function () {
            if (location.pathname.replace(/^\//, '') == this.pathname.replace(/^\//, '') && location.hostname == this.hostname) {
                var target = $(this.hash);
                target = target.length ? target : $('[name=' + this.hash.slice(1) + ']');
                if (target.length) {
                    $('html,body').animate({
                        scrollTop: target.offset().top
                    }, 1000);
                    return false;
                }
            }
        });
    });

    /* phone_form */
    $('.block_3 .btns button.grey').click(function () {
        $('.block_4').slideToggle();
        $('.fixScroll').click();
    });

    $("#phone_form").validate({
        messages: {
            phone: {
                required: 'Введите номер телефона'
            },
            name: {
                required: 'Введите имя'
            }
        }
    });

    /* step */
    $('.step_1 .show').click(function () {
        $('.step_1').hide();
        $('.step_2').fadeIn();
    });

    $('.show_category button').click(function () {
        $(this).parent().hide();
        $('.step_2_2').fadeIn();
    });

    $('.step_2 .item a').click(function () {
        $('.step_2').hide();
        var p = $(this).find('span').html();
        var id_category = $(this).attr("name");
        $('.loader span b').html(p);
        $('.step_4 .title i').html(p);
        $('.step_3').fadeIn();
        $('.loader article div').css('width', '100%');
        setTimeout(function () {
            $('.step_3').hide();
            $('.step_4').fadeIn();
            $('.loader article div').css('width', '0%');
        }, 3000);
        var item = $(".step_4 .clearfix div[name = " + id_category + "]").css("display", "block");
    });


    $('.step_4 .item').mouseenter(function () {
        if ($('body').hasClass('pc')) {
            $(this).find('article').fadeIn();
        }
    });
    $('.step_4 .item').mouseleave(function () {
        $(this).find('article').fadeOut();
    });

    $('.step_4 .item').click(function () {
        if (!$('body').hasClass('pc')) {
            $('.step_4 .item article').hide();
            $(this).find('article').fadeIn();
        }
    });

    /* language */
    $('.language__open').click(function () {
        $(this).parent().toggleClass('act');
        $(this).next().slideToggle();
    });

    /* order__phone */
    $('.order__phone').click(function () {
        $('.block_4').slideToggle();
        $('.fixScroll').click();
    });

    $('button.yellow').click(function () {
        $('.show button').click();
        $('.fixScrollTop').click();
    });

    $('.show button').click(function () {
        $('.fixScrollTop').click();
    });

    $('.preload').fadeOut();

    function return_to_select_category()
    {
        $('.step_4 .item').hide();
        $('.step_1').hide();
        $('.step_2').fadeIn();
        $('.step_3').hide();
        $('.step_4').hide();
    }


    $('#return_select_category').click(function(){
        return_to_select_category();
    });

     $('#button_return_cattegory').click(function(){
        return_to_select_category();
        $('.wrap-popup').fadeOut();
        $('body').css('overflow','visible');
    });


});