<?php

/**
 * @package WordPress
 * @subpackage Lending
 * @since Lending 1.0
 */
if (!isset($content_width)) {
    $content_width = 660;
}

if (function_exists('add_theme_support')) {
    add_theme_support('post-thumbnails');
}

if (function_exists('pll_register_string')) {
    pll_register_string('header_lending', 'header_lending');
    pll_register_string('step_1_lending', 'step_1_lending');
    pll_register_string('step_1_title_lending', 'step_1_title_lending');
    pll_register_string('step_1_category_tac_lending', 'step_1_category_tac_lending');
    pll_register_string('step_3_lending', 'step_3_lending');
    pll_register_string('step_4_lending', 'step_4_lending');
    pll_register_string('block_2_lending', 'block_2_lending');
    pll_register_string('block_3_title_lending', 'block_3_title_lending');
    pll_register_string('block_3_part_2_lending', 'block_3_part_2_lending');
    pll_register_string('block_4_lending', 'block_4_lending');
    pll_register_string('footer_lending', 'footer_lending');
    pll_register_string('view_lending', 'view_lending');
    pll_register_string('demo_lending', 'demo_lending');
    pll_register_string('testdrive_lending', 'testdrive_lending');
    pll_register_string('text_popup_inactive', 'text_popup_inactive');
    pll_register_string('button_popup_inactive', 'button_popup_inactive');
    pll_register_string('return_select_category', 'return_select_category');
    pll_register_string('text', 'new_item_text');
}

function themename_customize_register($wp_customize) {
    $wp_customize->add_section('themename_color_scheme', array('title' => __('Popup', 'themename'), 'priority' => 120));
    $wp_customize->add_setting('themename_theme_options[display]', array('default' => '0', 'capability' => 'edit_theme_options', 'type' => 'option'));
    $wp_customize->add_control('themename_display', array('label' => __('Display popup', 'themename'), 'section' => 'themename_color_scheme', 'settings' => 'themename_theme_options[display]', 'type' => 'checkbox'));
    $wp_customize->add_setting('themename_theme_options[time]', array('default' => '35', 'capability' => 'edit_theme_options', 'type' => 'option'));
    $wp_customize->add_control('themename_color_scheme', array('label' => __('Delay, sec', 'themename'), 'section' => 'themename_color_scheme', 'settings' => 'themename_theme_options[time]'));
}
add_action('customize_register', 'themename_customize_register');

function get_question() {
    $args = array('post_type' => 'question', "lang" => pll_current_language(), "post_status" => "publish");
    $loop = new WP_Query($args);
    $list_question = array();
    $index = 0;
    foreach ($loop->posts as $item) {
        $id = $item->ID;
        $custom = get_post_custom($id);
        foreach ($custom as $item_custom) {
            $id_question = $item_custom[0]["wpcf-id-question"];
        }
        $list_question[$id_question] = $loop->posts[$index]->post_content;
        $index++;
    }
    
    $text_question = "";
    if (isset($_GET["id_question"]) && is_numeric($_GET["id_question"])) {
        $id_question = $_GET["id_question"];
        
        $text_question = $list_question[$id_question];
        if ($text_question == "") {
            
            //$text_question = array_shift($list_question);
            $text_question = $list_question[1];
        }
    } 
    else {
        
        //$text_question = array_shift($list_question);
        $text_question = $list_question[1];
    }
    
    $html = "<span>" . $text_question . "</span>";
    return $html;
}

function custom_title() {
    $question = get_question();
    $question = str_replace("<span>", "", $question);
    $question = str_replace("</span>", "", $question);
    return $question;
}

/*function tm_get_params($get) {
    $url = "";
    if (isset($get["utm_source"]) && $get["utm_source"] != "") {
        $url.= "&utm_source=" . $get["utm_source"];
    }
    
    if (isset($get["utm_medium"]) && $get["utm_medium"] != "") {
        $url.= "&utm_medium=" . $get["utm_medium"];
    }
    
    if (isset($get["utm_term"]) && $get["utm_term"] != "") {
        $url.= "&utm_term=" . $get["utm_term"];
    }
    
    if (isset($get["utm_campaign"]) && $get["utm_campaign"] != "") {
        $url.= "&utm_campaign=" . $get["utm_campaign"];
    }
    return $url;
}*/
